# perk graph input generator
use XML::Simple;
use Data::Dumper;
use feature "switch";
use UNIVERSAL 'isa';


# defines
my $basedir = 'C:/Games/GUNROX/data/';
my $graphvizdir = '"c:\Program Files\Graphviz2.20\bin\dot.exe"';
my $languagefile = "english-1252.xml";


my $XML = XML::Simple->new();
my $language = $XML->XMLin($basedir . 'language/' . $languagefile);

# returns the displayed name for an item
sub GetName
{
  my $return = $_[0];
  my @path = split(/\./, $return);
  my $node = $language;
  foreach my $nodename (@path) {
    $node = $node->{$nodename};
  }
  return $node;
}

# adds edges to the graph for each requirement
sub PrintRequirenents
{
  my $output = $_[0];
  my $perc = $_[1];
  if(exists $perc->{required_perc}) {
    my $requiredlist = $perc->{required_perc};
    if(isa($requiredlist, 'ARRAY')) {
      foreach $required (@$requiredlist) {
        print $output $required . " -> " . $perc->{id} . ";\n";
      }
    } else {
      print $output $requiredlist . " -> " . $perc->{id} . ";\n";
    }
  }
}

# returns the displayed name for a stat
sub GetStatName
{
  my $internal = $_[0];
  my $external = $internal;
  
  given($internal) {
    when('required_level') {
      $external = "Required Level";
    }
    default {
      if(exists $language->{Stat}->{$internal}) {
        $external = $language->{Stat}->{$internal}
      }
    }
  }
  
  return $external;
}

# stats we're interested in
my @stats = (
  'required_level'
, 'hp'
, 'hpregeneration'
, 'maxstuffweight'
, 'maxstuffcount'
, 'apcommon'
, 'apmove'
, 'viewradius'
, 'viewpower'
, 'accuracy'
, 'critical_chance'
, 'critical_power'
, 'resistance_critical'
, 'resistance_critical_power'
, 'resistance_damage'
, 'resistance_poison'
, 'resistance_shock'
, 'resistance_blind'
, 'skill_melee'
, 'skill_pistol'
, 'skill_shotgun'
, 'skill_submachinegun'
, 'skill_assaultrifle'
, 'skill_sniperrifle'
, 'skill_grenade'
, 'skill_rocketlauncher'
, 'skill_heavygun'
, 'skill_energy '
, 'skill_trap>'
, 'skill_medikit'
); 
my %stattypes = (
  'required_level' => 'numberGTone'
, 'hp' => 'number'
, 'hpregeneration' => 'number'
, 'maxstuffweight' => 'number'
, 'maxstuffcount' => 'number'
, 'apcommon' => 'number'
, 'apmove' => 'number'
, 'viewradius' => 'number'
, 'viewpower' => 'number'
, 'accuracy' => 'number'
, 'critical_chance' => 'percentage'
, 'critical_power' => 'percentage'
, 'resistance_critical' => 'percentage'
, 'resistance_critical_power' => 'percentage'
, 'resistance_damage' => 'percentage'
, 'resistance_poison' => 'percentage'
, 'resistance_shock' => 'percentage'
, 'resistance_blind' => 'percentage'
, 'skill_melee' => 'number'
, 'skill_pistol' => 'number'
, 'skill_shotgun' => 'number'
, 'skill_submachinegun' => 'number'
, 'skill_assaultrifle' => 'number'
, 'skill_sniperrifle' => 'number'
, 'skill_grenade' => 'number'
, 'skill_rocketlauncher' => 'number'
, 'skill_heavygun' => 'number'
, 'skill_energy ' => 'number'
, 'skill_trap>' => 'number'
, 'skill_medikit' => 'number'
);

sub PrintPercEffects
{
  my $output = $_[0];
  my $item = $_[1];
  foreach my $stat (@stats) {
    if(exists $item->{$stat} && exists $stattypes{$stat}) {
      given($stattypes{$stat}) {
        when ('percentage') {
          print $output GetStatName($stat) . ' ' . $item->{$stat}*100 . '%\l';
        }
        when('numberGTone') {
          if($item->{$stat} > 1) {
            print $output GetStatName($stat) . ' ' . $item->{$stat} . '\l';
          }
        }
        default {
          print $output GetStatName($stat) . ' ' . $item->{$stat} . '\l';
        }
      }
    }
  }
}



sub PrintPercNode
{
  my $output = $_[0];
  my $perc = $_[1];
  
  print $output "$perc->{id} [\n";
  print $output 'label = "' . GetName($perc->{name}) . '\l';
  PrintPercEffects($output, $perc);
  print $output '"';
  print $output "]\n";
  
}


sub FillPercList
{
  my $output = $_[0];
  my $percdir = $basedir . 'prototype/perc';
  my $dir;
  opendir($dir, $percdir);
  my @files= readdir($dir);
  closedir($dir);

  foreach $file (@files) {
    if($file =~ /^perc/) {
      my $perc = $XML->XMLin($percdir . '/' . $file);
      PrintPercNode($output, $perc);
      PrintRequirenents($output, $perc);
    }
  }

}


my $output;
open($output, ">Percs.txt");

print $output "digraph Percs {\n";
print $output 'node [fontsize = "14" shape="box"];';
FillPercList($output);
print $output "}";
close $output;


my @imagetypes = qw(png svg);
print "Creating graph\n";
foreach $imagetype (@imagetypes) {
  print "$imagetype\n";
  system("$graphvizdir -T$imagetype -o Percs.$imagetype Percs.txt");
}

